/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.voxelutopia.ultramarine.data.registry.RecipeSerializerRegistry;
import com.voxelutopia.ultramarine.data.registry.RecipeTypeRegistry;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeSmeltingRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient primaryIngredient;
    protected final Ingredient secondaryIngredient;
    protected final ItemStack result;
    protected final float experience;
    protected final int cookingTime;

    public CompositeSmeltingRecipe(ResourceLocation pId, String pGroup, Ingredient primaryIngredient, Ingredient secondaryIngredient, ItemStack pResult, float pExperience, int pCookingTime) {
        this.id = pId;
        this.group = pGroup;
        this.primaryIngredient = primaryIngredient;
        this.secondaryIngredient = secondaryIngredient;
        this.result = pResult;
        this.experience = pExperience;
        this.cookingTime = pCookingTime;
    }

    public boolean m_5818_(Container pContainer, @NotNull Level pLevel) {
        return this.primaryIngredient.test(pContainer.m_8020_(0)) && this.secondaryIngredient.test(pContainer.m_8020_(1));
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container pContainer, @NotNull RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public boolean partialMatch(Container pContainer, Level pLevel) {
        return this.primaryIngredient.or((Predicate)this.secondaryIngredient).test(pContainer.m_8020_(0));
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public Ingredient getPrimaryIngredient() {
        return this.primaryIngredient;
    }

    public Ingredient getSecondaryIngredient() {
        return this.secondaryIngredient;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.COMPOSITE_SMELTING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.COMPOSITE_SMELTING.get();
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public float getExp() {
        return this.experience;
    }

    public static class Serializer
    implements RecipeSerializer<CompositeSmeltingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("ultramarine", "composite_smelting");
        private static final int defaultCookingTime = 200;

        protected Serializer() {
        }

        public CompositeSmeltingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            ItemStack result;
            if (!pJson.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            String group = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
            Ingredient primaryIngredient = Serializer.parseIngredient(pJson, "primary_ingredient");
            Ingredient secondaryIngredient = Serializer.parseIngredient(pJson, "secondary_ingredient");
            if (pJson.get("result").isJsonObject()) {
                result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
            } else {
                String s1 = GsonHelper.m_13906_((JsonObject)pJson, (String)"result");
                ResourceLocation resourcelocation = new ResourceLocation(s1);
                result = new ItemStack((Holder)ForgeRegistries.ITEMS.getHolder(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
            }
            float exp = GsonHelper.m_13820_((JsonObject)pJson, (String)"experience", (float)0.0f);
            int cookingTime = GsonHelper.m_13824_((JsonObject)pJson, (String)"cookingtime", (int)200);
            return new CompositeSmeltingRecipe(pRecipeId, group, primaryIngredient, secondaryIngredient, result, exp, cookingTime);
        }

        @Nullable
        public CompositeSmeltingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            String group = pBuffer.m_130277_();
            Ingredient primary = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient secondary = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack result = pBuffer.m_130267_();
            float exp = pBuffer.readFloat();
            int cookingTime = pBuffer.m_130242_();
            return new CompositeSmeltingRecipe(pRecipeId, group, primary, secondary, result, exp, cookingTime);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, CompositeSmeltingRecipe pRecipe) {
            pBuffer.m_130070_(pRecipe.group);
            pRecipe.primaryIngredient.m_43923_(pBuffer);
            pRecipe.secondaryIngredient.m_43923_(pBuffer);
            pBuffer.m_130055_(pRecipe.result);
            pBuffer.writeFloat(pRecipe.experience);
            pBuffer.m_130130_(pRecipe.cookingTime);
        }

        private static Ingredient parseIngredient(JsonObject json, String member) {
            JsonArray ingredientRaw = GsonHelper.m_13885_((JsonObject)json, (String)member) ? GsonHelper.m_13933_((JsonObject)json, (String)member) : GsonHelper.m_13930_((JsonObject)json, (String)member);
            return Ingredient.m_43917_((JsonElement)ingredientRaw);
        }
    }
}

